#include "precompiled.h"

/*
 * wxJavaScript - htmllink.cpp
 *
 * Copyright (c) 2002-2007 Franky Braem and the wxJavaScript project
 *
 * Project Info: http://www.wxjavascript.net or http://wxjs.sourceforge.net
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
 * USA.
 *
 * $Id: htmllink.cpp 612 2007-03-12 22:08:35Z fbraem $
 */
#ifndef WX_PRECOMP
	#include <wx/wx.h>
#endif

#include "../../common/main.h"
#include "jsevent.h"
#include "htmllink.h"

using namespace wxjs;
using namespace wxjs::gui;

/***
 * <file>event/htmllink</file>
 * <module>gui</module>
 * <class name="wxHtmlLinkEvent" prototype="@wxEvent">
 *  This event class is used for the events generated by @wxHtmlWindow.
 * </class>
 */
WXJS_INIT_CLASS(HtmlLinkEvent, "wxHtmlLinkEvent", 0)

/***
 * <properties>
 *	<property name="href" type="String" readonly="Y">
 *	 Return HREF value of the &lt;a&gt; tag.
 *  </property>
 *	<property name="target" type="String" readonly="Y">
 *	 Return TARGET value of the &lt;a&gt; tag.
 *  </property>
 * </properties>
 */
WXJS_BEGIN_PROPERTY_MAP(HtmlLinkEvent)
	WXJS_READONLY_PROPERTY(P_HREF, "href")
	WXJS_READONLY_PROPERTY(P_TARGET, "target")
WXJS_END_PROPERTY_MAP()

bool HtmlLinkEvent::GetProperty(PrivHtmlLinkEvent *p, JSContext *cx, JSObject* WXUNUSED(obj), int id, jsval *vp)
{
    wxHtmlLinkEvent *event = p->GetEvent();
    wxHtmlLinkInfo info = event->GetLinkInfo();
	switch(id)
	{
	case P_HREF:
		*vp = ToJS(cx, info.GetHref());
		break;
	case P_TARGET:
		*vp = ToJS(cx, info.GetTarget());
		break;
	}
	return true;
}
