/* fpclassifyf4 - for each element of vector x, return classification of x': FP_NAN, FP_INFINITE, FP_NORMAL, FP_SUBNORMAL, FP_ZERO
   Copyright (C) 2006, 2007 Sony Computer Entertainment Inc.
   All rights reserved.

   Redistribution and use in source and binary forms,
   with or without modification, are permitted provided that the
   following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the Sony Computer Entertainment Inc nor the names
      of its contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ___SIMD_MATH_FPCLASSIFYF4_H___
#define ___SIMD_MATH_FPCLASSIFYF4_H___

#include <simdmath.h>
#include <spu_intrinsics.h>
#include <math.h>

static inline vector signed int
_fpclassifyf4 (vector float x)
{
  vec_uint4 zero = spu_splats((unsigned int)0x00000000);

  vec_uint4 mask;
  vec_uint4 unclassified = spu_splats((unsigned int)0xffffffff);
  vec_int4 classtype = (vec_int4)zero;

  //FP_NAN: NaN not supported on SPU, never return FP_NAN

  //FP_INFINITE: Inf not supported on SPU, never return FP_INFINITE

  //FP_ZERO: zero exponent and zero mantissa
  mask = spu_cmpeq( spu_andc( (vec_uint4)x, spu_splats((unsigned int)0x80000000)), zero );
  classtype = spu_sel( classtype, spu_splats((int)FP_ZERO), mask );
  unclassified = spu_andc( unclassified, mask );

  //FP_SUBNORMAL: zero exponent and non-zero mantissa
  mask = spu_and( spu_cmpeq( spu_and( (vec_uint4)x, spu_splats((unsigned int)0x7f800000)), zero ),
		  spu_cmpgt( spu_and( (vec_uint4)x, spu_splats((unsigned int)0x007fffff)), zero ) );
  classtype = spu_sel( classtype, spu_splats((int)FP_SUBNORMAL), mask );
  unclassified = spu_andc( unclassified, mask );

  //FP_NORMAL: none of the above
  classtype = spu_sel( classtype, spu_splats((int)FP_NORMAL), unclassified );

  return classtype;
}

#endif
