#!/usr/bin/env python

'''Early demonstration of XML/XHTML/CSS layout and rendering.  Use the
scroll-wheel to move up and down the document and resize the window to
reflow the layout.
'''

__docformat__ = 'restructuredtext'
__version__ = '$Id$'

from pyglet.gl import *
from pyglet.window import Window
from pyglet import clock

from layout import *

window = Window(visible=False, vsync=False, resizable=True)

data = '''<?xml version="1.0"?>
<html>  
  <head>
    <style>
      h1 {border-bottom: 1px solid; 
          background-image: url(examples/stripe.png)}
      body {background-image: url(examples/paper.jpg); 
            background-repeat: repeat;}
      p {padding: 2px}
      p:hover {color:red; padding: 0px; border: 2px dashed blue;}
    </style>
  </head>
  <body>
    <h1>The Frog King</h1>
    <h2>Brothers Grimm</h2>
    <p>
      In olden times when <span id="wishing">wishing</span> still helped one,
      there lived a king whose daughters were all beautiful, but the youngest
      was so beautiful that the sun itself, which has seen so much, was
      astonished whenever it <span id="shone">shone</span> in her face.  Close
      by the king's castle lay a great dark forest, and under an old lime-tree
      in the forest was a well, and when the day was very warm, the king's
      child went out into the forest and sat down by the side of the cool
      fountain, and when she was bored she took a golden ball, and threw it up
      on high and caught it, and this ball was her favorite plaything.
    </p>
    <p id="para2">
      Now it so happened that on one occasion the princess's golden ball
      did not fall into the little hand which she was holding up for it, but
      on to the ground beyond, and rolled straight into the water. The king's
      daughter followed it with her eyes, but it vanished, and the well was
      deep, so deep that the bottom could not be seen. At this she began to
      cry, and cried louder and louder, and could not be comforted. And as she
      thus lamented someone said to her, "What ails you, king's daughter? You
      weep so that even a stone would show pity." 
    </p>
    <p>
      She looked round to the side from whence the voice came, and saw a
      frog stretching forth its big, ugly head from the water. "Ah, old
      water-splasher, is it you," she said, "I am weeping for my golden
      ball, which has fallen into the well." "Be quiet, and do not weep,"
      answered the frog, "I can help you, but what will you give me if I
      bring your plaything up again?" "Whatever you will have, dear frog,"
      said she, "My clothes, my pearls and jewels, and even the golden crown
      which I am wearing." The frog answered, "I do not care for your
      clothes, your pearls and jewels, nor for your golden crown, but if you
      will love me and let me be your companion and play-fellow, and sit by
      you at your little table, and eat off your little golden plate, and
      drink out of your little cup, and sleep in your little bed---if you
      will promise me this I will go down below, and bring you your golden
      ball up again."
    </p>
    <p>
      "Oh yes," said she, "I promise you all you wish, if you will but bring
      me my ball back again." But she thought, "How the silly frog does
      talk. All he does is to sit in the water with the other frogs, and
      croak. He can be no companion to any human being."
    </p>
    <p>
      But the frog when he had received this promise, put his head into the
      water and sank down; and in a short while came swimmming up again with
      the ball in his mouth, and threw it on the grass. The king's daughter
      was delighted to see her pretty plaything once more, and picked it up,
      and ran away with it. "Wait, wait," said the frog. "Take me with you.
      I can't run as you can." But what did it avail him to scream his
      croak, croak, after her, as loudly as he could. She did not listen to
      it, but ran home and soon forgot the poor frog, who was forced to go
      back into his well again.
    </p>
    <p>
      The next day when she had seated herself at table with the king and
      all the courtiers, and was eating from her little golden plate,
      something came creeping splish splash, splish splash, up the marble
      staircase, and when it had got to the top, it knocked at the door and
      cried, "Princess, youngest princess, open the door for me." She ran to
      see who was outside, but when she opened the door, there sat the frog
      in front of it. Then she slammed the door to, in great haste, sat down
      to dinner again, and was quite frightened. The king saw plainly that
      her heart was beating violently, and said, "My child, what are you so
      afraid of? Is there perchance a giant outside who wants to carry you
      away?" "Ah, no," replied she. "It is no giant but a disgusting frog."
    </p>
    <p>
      "What does a frog want with you?" "Ah, dear father, yesterday as I was
      in the forest sitting by the well, playing, my golden ball fell into
      the water. And because I cried so, the frog brought it out again for
      me, and because he so insisted, I promised him he should be my
      companion, but I never thought he would be able to come out of his
      water. And now he is outside there, and wants to come in to me."
    </p>
    <p>
      In the meantime it knocked a second time, and cried, "Princess,
      youngest princess, open the door for me, do you not know what you said
      to me yesterday by the cool waters of the well. Princess, youngest
      princess, open the door for me."
    </p>
    <p>
      Then said the king, "That which you have promised must you perform. Go
      and let him in." She went and opened the door, and the frog hopped in
      and followed her, step by step, to her chair. There he sat and cried,
      "Lift me up beside you." She delayed, until at last the king commanded
      her to do it. Once the frog was on the chair he wanted to be on the
      table, and when he was on the table he said, "Now, push your little
      golden plate nearer to me that we may eat together." She did this, but
      it was easy to see that she did not do it willingly. The frog enjoyed
      what he ate, but almost every mouthful she took choked her. At length
      he said, "I have eaten and am satisfied, now I am tired, carry me into
      your little room and make your little silken bed ready, and we will
      both lie down and go to sleep."
    </p>
    <p>
      The king's daughter began to cry, for she was afraid of the cold frog
      which she did not like to touch, and which was now to sleep in her
      pretty, clean little bed. But the king grew angry and said, "He who
      helped you when you were in trouble ought not afterwards to be
      despised by you." So she took hold of the frog with two fingers,
      carried him upstairs, and put him in a corner, but when she was in bed
      he crept to her and said, "I am tired, I want to sleep as well as you,
      lift me up or I will tell your father." At this she was terribly
      angry, and took him up and threw him with all her might against the
      wall.  "Now, will you be quiet, odious frog," said she. But when he
      fell down he was no frog but a king's son with kind and beautiful
      eyes. He by her father's will was now her dear companion and husband.
      Then he told her how he had been bewitched by a wicked witch, and how
      no one could have delivered him from the well but herself, and that
      to-morrow they would go together into his kingdom.
    </p>
    <p>
      Then they went to sleep, and next morning when the sun awoke them, a
      carriage came driving up with eight white horses, which had white
      ostrich feathers on their heads, and were harnessed with golden
      chains, and behind stood the young king's servant Faithful Henry.
      Faithful Henry had been so unhappy when his master was changed into a
      frog, that he had caused three iron bands to be laid round his heart,
      lest it should burst with grief and sadness. The carriage was to
      conduct the young king into his kingdom.  Faithful Henry helped them
      both in, and placed himself behind again, and was full of joy because
      of this deliverance. And when they had driven a part of the way the
      king's son heard a cracking behind him as if something had broken. So
      he turned round and cried, "Henry, the carriage is breaking." "No,
      master, it is not the carriage. It is a band from my heart, which was
      put there in my great pain when you were a frog and imprisoned in the
      well." Again and once again while they were on their way something
      cracked, and each time the king's son thought the carriage was
      breaking, but it was only the bands which were springing from the
      heart of Faithful Henry because his master was set free and was happy.  
    </p>
</body>
</html> '''

layout = Layout()
layout.set_xhtml(data)

@select('body')
def on_mouse_press(element, x, y, button, modifiers):
    print 'I am the body'
layout.push_handlers(on_mouse_press)

@select('h1')
def on_mouse_press(element, x, y, button, modifiers):
    print 'I am the frog!'
    return EVENT_UNHANDLED
layout.push_handlers(on_mouse_press)

@select('h2')
def on_mouse_press(element, x, y, button, modifiers):
    print 'I am brother Grimm!'
layout.push_handlers(on_mouse_press)

@select('#wishing')
def on_mouse_press(element, x, y, button, modifiers):
    e = layout.document.get_element('shone')
    if 'border' not in e.style:
        e.style['border'] = '1px solid blue'
        e.style['color'] = '#f0f'
    else:
        del e.style['border']
        del e.style['color']
layout.push_handlers(on_mouse_press)

@select('#shone')
def on_mouse_press(element, x, y, button, modifiers):
    e = layout.document.get_element('wishing')
    if e.style['display'] == 'none':
        del e.style['display'] 
    else:
        e.style['display'] = 'none'
layout.push_handlers(on_mouse_press)

@select('#para2')
def on_mouse_press(element, x, y, button, modifiers):
    element.add_text('One fish two fish red fish blue fish.')
layout.push_handlers(on_mouse_press)

window.push_handlers(layout)


def print_style(style, indent=''):
    import textwrap
    print '\n'.join(textwrap.wrap(repr(style), initial_indent=indent,
            subsequent_indent=indent))
    if style.parent:
        print_style(style.parent, '  ' + indent)

def print_element(element, indent=''):
    import textwrap
    print '\n'.join(textwrap.wrap(repr(element), initial_indent=indent,
            subsequent_indent=indent))
    if element.style_context:
        print_style(element.style_context, indent + '  ')
    for child in element.children:
        print_element(child, '  ' + indent)

glClearColor(1, 1, 1, 1)

window.set_visible()

while not window.has_exit:
    clock.tick()
    print 'FPS = %.2f\r' % clock.get_fps(),

    window.dispatch_events()
    glClear(GL_COLOR_BUFFER_BIT)
    layout.draw()

    window.flip()
