#include <stdio.h>
#include <cstdlib>
#include <iostream>
#include <string>

using std::cout;
using std::cin;
using std::endl;
using std::string;

#include <vector>
#include <map>

using std::vector;
using std::map;

#define BUFFSIZE 512
#define VERSION "0.0.2"

string dcc_execCommand(const string& cmd) {

	string output;
	FILE* fp;
	char buffer[BUFFSIZE];
	fp = popen( cmd.c_str(), "r" );
	while(fgets(buffer, BUFFSIZE, fp) != NULL) {
	
		output += buffer;
	}
	pclose(fp);
	return output;
}

string dcc_getVersion() {

	return dcc_execCommand("distcc --version");
}

string dcc_undoSubst(const string& str) {

	string newstr = str;
	string::size_type start = 0;
	
	while ( (start = newstr.find("%2F")) != string::npos )
		newstr.replace(start, 3, "/");

	return newstr;
}

int dcc_probeHost(const string& hostname, const string& distccpath, string& probe_time ) {

	int ret = 0;
	
	// try compilation on remote host (-S: just compile, no linking)
	string cmdline = "DISTCC_HOSTS=\"" + hostname + "\" DISTCC_VERBOSE=1 ./cachestderror " + dcc_undoSubst(distccpath) + "/distcc probe.cpp -S -o /dev/null";
	string output = dcc_execCommand(cmdline);

	// check if dist. compilation worked.
	string diagn = "compile on " + hostname + " completed ok";
	if (output.find(diagn) != string::npos)
		ret = 1;
	else
		return 0;

	// get probe time (= compilation time)
	string time_string = "elapsed compilation time ";
	string::size_type start = output.find(time_string) + time_string.length(),
		end = output.find('s', start);
	probe_time = output.substr(start, end - start);	

	return ret;
}

void dcc_writeAddress() {

	cout << "<address>" << endl;
	cout << "<p align=\"right\">" << endl;
	cout << " <small>" << endl;
	cout << "  <a href=\"http://lumumba.luc.ac.be/~tom/index.php?selected=projects\">distccWebView</a> " << VERSION << "<br/>" << endl;
	cout << "  <a href=\"mailto:tom.vanlaerhoven@luc.ac.be\">tom.vanlaerhoven@luc.ac.be</a>" << endl;
	cout << " </small>" << endl;
	cout << "</p>" << endl;
	cout << "</address>" << endl;
}

// currently not used
void dcc_writeValidXHTML11() {                                                         

	cout << "\
		<a href=\"http://validator.w3.org/check/referer\">\
		 <img src=\"http://www.w3.org/Icons/valid-xhtml11\" class=\"imagelinknoborder\" alt=\"Valid XHTML 1.1!\" height=\"31\" width=\"88\" />\
		</a>\
	" << endl;
}

map<string, string> dcc_parseArguments(string args) {

    map<string, string> argmap;
    unsigned argstart = 0, argend, nameend;    

    while ( argstart != string::npos ) {

        argend = args.find_first_of("&", argstart);
        nameend = args.find_first_of("=", argstart);
        argmap[args.substr(argstart, nameend - argstart)] = args.substr(nameend + 1, argend - nameend - 1);
        
	argstart = (argend == string::npos)?string::npos : argend + 1;
    }   

    return argmap;
}

// output html header, including css
void dcc_writeHeader() {

	cout << "\
		<?xml version=\"1.0\"?> \
		<!DOCTYPE html PUBLIC: \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> \
		<html xmlns = \"http://www.w3.org/1999/xhtml\"> \
	        <head>\
			<title>distccWebView</title> \
			<style type=\"text/css\"> \
					body, p td, tr, a {font-family: Tahoma, Arial, Helvetica, sans-serif;} \
					h3 {text-decoration: underline; bold;} \
			</style> \
		</head>"
	<< endl;
}

void dcc_writeCell(const string& str) {

	cout << "<td>" << str << "</td>" << endl;
}

void dcc_writeUpTable(const string& hosts, const string& distccpath) {

	string::size_type off = 0, end;
	
	// write version
	cout << "<h3>distcc info</h3>" << endl;
	cout << dcc_getVersion() << "<br /><br />" << endl;

	// open table
	cout << "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"50%\">" << endl;
	
	// table header
	cout << "<tr>";
	dcc_writeCell("<h3>Hostname</ h3>");
	dcc_writeCell("<h3>Status</ h3>");
	dcc_writeCell("<h3>Probe time</ h3>");
	cout << "</tr>" << endl;

	do {	
		end = hosts.find_first_of('+', off);
		string host = hosts.substr(off, (end - off));
		string probe_time;
		
		cout << "<tr>" << endl;
		dcc_writeCell(host);
		if ( dcc_probeHost(host, distccpath, probe_time) )
			dcc_writeCell("Up");
		else
			dcc_writeCell("Down");
		off = end + 1;

		dcc_writeCell(probe_time);
		
		cout << "</tr>" << endl;
	}
	while (end != string::npos);
	
	// close table
	cout << "</table>" << endl;
}

int main() {

	// Provide html content type
	cout << "Content-Type: text/html" << endl << endl;

	// Write header
	dcc_writeHeader();

	// Write body
	cout << "\
		<body> \
		<h2>distccWebView</h2>\
		<p>"
	<< endl;

	// fetch form post data
	string postString;
	int contentLength = 0;
	if ( getenv("CONTENT_LENGTH") ) {

		contentLength = atoi( getenv("CONTENT_LENGTH") );
		char* buffer = new char[contentLength];
		cin.read( buffer, contentLength );
		postString = buffer;
		delete [] buffer;
	}

	if ( contentLength <= 0 )
		return 0;

	// Parse post data
	map<string, string> argmap = dcc_parseArguments(postString);
	map<string, string>::iterator host_it = argmap.find("DISTCC_HOSTS"),
		distcc_it = argmap.find("DISTCC_PATH");
    
	// HOST(s) provided
 	if ( host_it != argmap.end() ) {

		string distccpath;
		// if no distcc path is provided, assume it is in the PATH var
		if ( distcc_it == argmap.end() )
			distccpath = "/usr/bin";
		else
			distccpath = distcc_it->second;

		dcc_writeUpTable(host_it->second, distccpath);
	}
    	else
		cout << "No hosts supplied for probing!" << endl;

	// Closing html
	cout << "</p>" << endl;
	cout << "<hr>" << endl;
	//dcc_writeValidXHTML11();
	dcc_writeAddress();
	cout << "</body>" << endl;
	cout << "</html>";
    	return 0;
}
