/* --------------------------------------------------------------------------

   flactag -- A tagger for single album FLAC files with embedded CUE sheets
   						using data retrieved from the MusicBrainz service

   Copyright (C) 2006 Andrew Hawkins
   
   This file is part of flactag.
   
   Flactag is free software; you can redistribute it and/or
   modify it under the terms of v2 of the GNU Lesser General Public
   License as published by the Free Software Foundation.
   
   Flactag is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   
   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

     $Id: Cuesheet.h 39 2006-09-22 12:20:06Z andy $

----------------------------------------------------------------------------*/

#ifndef _CUESHEET_H
#define _CUESHEET_H

#include <map>

#include "CuesheetTrack.h"

class CCuesheet
{
public:
	CCuesheet();
	
	void Clear();
	
	void AddTrack(const CCuesheetTrack& Track);
	FLAC__byte NumTracks() const;
	CCuesheetTrack Track(FLAC__byte TrackNum) const;
	void SetLeadout(FLAC__uint64 Leadout);
	FLAC__uint64 Leadout() const;
	FLAC__byte FirstTrack() const;
	FLAC__byte LastTrack() const;
	
private:
	std::map<FLAC__byte,CCuesheetTrack> m_Tracks;
	FLAC__uint64 m_Leadout;
	FLAC__byte m_FirstTrack;
	FLAC__byte m_LastTrack;
};

#endif
