/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "MediaDeviceConfirmDialog.h"

#include "container.h"
#include "containerutils.h"
#include "logger.h"
#include "Scrobbler-1.2.h"
#include <QtGui>
#include <QString>
#include <QtDebug>


MediaDeviceConfirmDialog::MediaDeviceConfirmDialog( const QString& username, QWidget *parent )
        : QDialog( parent, Qt::Sheet ),
          m_username( username )
{
    m_tracks = ScrobbleCache::mediaDeviceCache( m_username ).tracks();
}


void
MediaDeviceConfirmDialog::setupUi()
{
    ui.setupUi( this );
    ui.tracksWidget->setColumnHidden( 3, true );

    addTracksToView();
    
    QPixmap p( dataPath( "app_55.png" ) );
    p = p.scaled( 32, 32, Qt::IgnoreAspectRatio, Qt::SmoothTransformation );
    ui.iconLabel->setPixmap( p );

////// this magnificent hack bought to you by teh mxcl
    // @short set the dialog's width to avoid horizontal scrollbars
    struct NoProtection : QAbstractItemView
    {
        using QAbstractItemView::sizeHintForColumn;
    };

    int w = 0, desiredwidth = 0;
    for (int x = 0; x < ui.tracksWidget->columnCount(); ++x) {
        desiredwidth = reinterpret_cast<NoProtection*>(ui.tracksWidget)->sizeHintForColumn( x );
        w += desiredwidth;
    }
    
    ui.tracksWidget->setMinimumWidth( w );
    if (m_tracks.count() > 10 )
        ui.tracksWidget->setMinimumHeight( ui.tracksWidget->sizeHint().height() * 2 );

    //make us always the right size
    adjustSize();

///////
    connect( ui.scrobble, SIGNAL(clicked()), SLOT(accept()) );
    connect( ui.cancel,   SIGNAL(clicked()), SLOT(reject()) );
    connect( ui.toggle,   SIGNAL(clicked()), SLOT(toggleChecked()) );
    
///////
    activateWindow();
}


void
MediaDeviceConfirmDialog::addTracksToView()
{
    QList<QTreeWidgetItem*> items;
    foreach (TrackInfo t, m_tracks)
    {
        QDateTime dt = QDateTime::fromTime_t( t.timeStamp() );
        
        QStringList tokens;
        tokens += t.artist();
        tokens += t.track();
        tokens += dt.toString( "dd/MM/yy hh:mm" );
        tokens += QString::number( t.timeStamp() );
        tokens += QString::number( t.playCount() );

        QTreeWidgetItem* widget = new QTreeWidgetItem( tokens );
        widget->setFlags( widget->flags() | Qt::ItemIsUserCheckable );
        widget->setCheckState( 0, Qt::Checked );
        
        items += widget;
    }

    ui.tracksWidget->insertTopLevelItems( 0, items );
    ui.tracksWidget->resizeColumnToContents( 0 );
    ui.tracksWidget->resizeColumnToContents( 1 );
    ui.tracksWidget->resizeColumnToContents( 2 );
    ui.tracksWidget->resizeColumnToContents( 4 );

    ui.tracksWidget->setSortingEnabled( true );
    ui.tracksWidget->sortByColumn( 3, Qt::DescendingOrder );

    QString text = tr( "You have just synced your iPod.\n\n"
            "Last.fm found %n new track(s) since the last time you synced. "
            "Do you want to scrobble these?", "", items.count() );
    ui.messageLabel->setText( text );
}


void
MediaDeviceConfirmDialog::toggleChecked()
{
    for (int x = 0; x < ui.tracksWidget->topLevelItemCount(); ++x) 
    {
        QTreeWidgetItem* i = ui.tracksWidget->topLevelItem( x );
        i->setCheckState( 0, i->checkState( 0 ) == Qt::Checked ? Qt::Unchecked : Qt::Checked );
    }
}


int
MediaDeviceConfirmDialog::exec()
{
    if (m_tracks.count())
    {
        setupUi();
        return QDialog::exec();
    }
    else
        return QDialog::Rejected;
}


QList<TrackInfo>
MediaDeviceConfirmDialog::tracks() const
{
    QList<TrackInfo> tracks;
    for (int x = 0; x < m_tracks.count(); ++x)
        if (ui.tracksWidget->topLevelItem( x )->checkState( 0 ) == Qt::Checked)
            tracks += m_tracks[x];
    return tracks;
}
