/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef MEDIADEVICECONFIRMDIALOG_H
#define MEDIADEVICECONFIRMDIALOG_H

#include <QPixmap>
#include <QDialog>
#include "TrackInfo.h"

#include "ui_MediaDeviceConfirmDialog.h"


class MediaDeviceConfirmDialog : public QDialog
{
    Q_OBJECT

public:
    MediaDeviceConfirmDialog( const QString& username, QWidget *parent = 0 );

    int exec();
    

    QList<TrackInfo> tracks() const;

public slots:
    void toggleChecked();

private:
    void setupUi();
    void addTracksToView();

    Ui::MediaDeviceConfirmDialog ui;

    QString const m_username;
    QList<TrackInfo> m_tracks;
};

#endif // MEDIADEVICECONFIRMDIALOG_H
