/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef LAST_FM_CONTAINER_H
#define LAST_FM_CONTAINER_H

#include "ui_container.h"
#include "ui_playcontrols.h"

#include "imagebutton.h"
#include "RadioEnums.h"
#include "WebService/fwd.h"
#include "lastfmtools_common.h"

int main( int, char** );


class Container : public QMainWindow
{
    Q_OBJECT

        friend class SysTray; // needed in SysTray ctor
        friend int main( int, char** ); // singleton is instantiated here

        static Container *s_instance;

    public:
        ~Container();
    
        static Container& instance() { return *s_instance; }
        
        class ScrobblerManager &scrobbler() { return *m_scrobbler; }
        class CPlayerListener& listener() { return *m_listener; }
        class Radio& radio() { return *m_radio; }
        class RecommendDialog& recommendDialog() { return *m_recommendDlg; }
        
        bool isClosingDown() const { return m_closingDown; }
        
        #ifdef Q_WS_MAC
            QActionGroup* sysTrayActions() { return m_sysTrayActions; }
        #endif
        
        int stackIndex() const { return ui.stack->currentIndex(); }
        
        /** true if scrobbling from media player, tuning into radio or playing radio */
        bool isTuningInOrPlaying() const; //TODO REMOVE

    public slots:
        void initServices();

        void checkForUpdates( bool invokedByUser = true );
        void showSettingsDialog();
        void showRecommendDialog();
        void showTagDialog( int defaultTagType = -1 );
        void showTagDialogMD();
        void showMetaDataWidget() { ui.stack->setCurrentIndex( 1 ); }
        void showRestState();
        
        void restoreWindow() { showNormal(); activateWindow(); raise(); }
        
        void toggleWindowVisibility();

        void setPreloadStation( StationUrl url ) { m_preloadStation = url; }
        void actualClose( bool confirm = true );

        void addMediaDevice( const QString& uid );        

    signals:
        void newSong( MetaData song );
        void playStarted();
        void stackIndexChanged( int );

    protected:
        void closeEvent( QCloseEvent* );
        void dropEvent( QDropEvent* );
        void dragEnterEvent( QDragEnterEvent* );
        void dragMoveEvent( QDragMoveEvent* );
        bool event( QEvent* );

    private:
        // Singleton, hence private ctor
        Container();

        void initListener();
        void initTray();

        void switchPlayButton( bool enabled );
        void loadExtensions();

        void addExtensionToTabWidget( class ExtensionInterface* extension );

        Ui::ContainerWindow ui;
        Ui::PlayControls ui_playcontrols;

        QAction* m_sidebarActionWithIcon;
        QAction* m_skipAction;
        QAction* m_playAction;
        QAction* m_stopAction;
        QLabel*  m_scrobbleLabel;
        #ifdef Q_WS_MAC
            QAction* m_sysTrayActionPlay;
            QAction* m_sysTrayActionStop;
            QActionGroup* m_sysTrayActions;
        #endif
            
        ImageButton *m_scrobbleToggle;
      #ifdef Q_WS_MAC
        ImageButton *m_scrobbleGraphicMac;
      #endif
        QPixmap m_scrobbleNormal;
        QPixmap m_scrobbleDisabled;

        Radio* m_radio;
        ExtensionInterface* m_eUserInfo;

        class SideBarTree* m_sidebar;
        class RestStateWidget* m_rest_state_widget;
        class MetaDataExtension* m_metaDataExtension;
        class SysTray* m_sysTray;
        class SettingsDialog *m_settingsDialog;
        class CPlayerListener *m_listener;
        class CAutoUpdater *m_updater;
        class ScrobblerManager *m_scrobbler;
        class ControlInterface* m_iControl;
    
        /** having a persistent copy means whatever the user entered last time
          * into the input widgets and that, stays, and load time is quicker too
          */
        RecommendDialog *m_recommendDlg;
        
        MetaData m_metaData;
        QByteArray m_sidebarState;
        StationUrl m_preloadStation;
        
        bool m_userCheck;
        bool m_sidebarEnabled;
        bool m_stopped;
        
        int m_lastVolume;
        
        bool m_closingDown;
        
        QTimer* m_showRestStateTimer;

    private slots:
        void about();
        void addUser();
        void deleteUser();
        void getPlugin();
        void showUserMenu();
        
        /** opens log in default .log handler */
        void onAltShiftL();
        /** opens helperlog in default .log handler */
        void onAltShiftH();
        /** opens savePath() in default handler */
        void onAltShiftF();

        void toggleSidebar();
        void toggleScrobbling();
        void toggleDiscoveryMode();

        void onRadioStateChange( RadioState newState );
        void onRadioError( RadioError error, const QString& message = "" );
        void onRadioBuffering( int size, int total );

        void setNewSong( TrackInfo data, bool songStarted );
        
        void displayUrlInStatusBar( const QString& url );
        void displayUnscrobblableStatus( TrackInfo::ScrobblableStatus status );
        void statusMessage( const QString& message ) { statusBar()->showMessage( message ); }

        void love();
        void ban();
        void skip();

        void play();
        void stop();

        void volumeUp();
        void volumeDown();
        void mute();
        
        void showFAQ();
        void showForums();
        void inviteAFriend();

        void userSelected( QAction* action );
        void updateCheckDone( bool updatesAvailable, bool error, QString errorMsg );
        void updateWindowTitle( const MetaData& );
        void updateUserStuff( UserSettings& user );

        void listenerException( QString msg );
        
        void onScrobblerStatusChange( int, const QVariant& );
        
        /** means track from an external application, not a radio scrobble */
        void onTrackScrobbled( const TrackInfo& track );
        void setTrackScrobbled();
        
        void onRestStateTimerTimeout();

        void minimiseToTray();
        void gotoProfile();
        void crash();

        void webServiceSuccess( Request* );
        void webServiceFailure( Request* );
};


namespace The
{
    inline Container& container() { return Container::instance(); }
}

#endif // CONTAINER_H
