/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "containerutils.h"
#include "iconshack.h"
#include "logger.h"


QPixmap
IconShack::icon( QPixmap icons[], UserIconColour c )
{
    if (!mbIconsLoaded)
        LoadIcons();

    if (c == eNone || icons[c].isNull())
        return icons[ eRed ];
    else
        return icons[c];
}


QPixmap
IconShack::GetGoodUserIcon( UserIconColour eColour )
{
    return icon( maGoodIcons, eColour );
}


QPixmap
IconShack::GetGoodUserIconCollapsed( UserIconColour eColour )
{
    return icon( maGoodIconsCollapsed, eColour );
}


QPixmap
IconShack::GetGoodUserIconExpanded( UserIconColour eColour )
{
    return icon( maGoodIconsExpanded, eColour );

}


QPixmap
IconShack::GetExclUserIcon( UserIconColour eColour )
{
    return icon( maExclIcons, eColour );
}    


QPixmap
IconShack::GetDisabledUserIcon( UserIconColour eColour )
{
    return icon( maDisabledIcons, eColour );
}    


void
IconShack::LoadIcons()
{
    maGoodIcons[eRed].load( dataPath( "icons/user_red.png" ) );
    maGoodIcons[eBlue].load( dataPath( "icons/user_blue.png" ) );
    maGoodIcons[eGreen].load( dataPath( "icons/user_green.png" ) );
    maGoodIcons[eOrange].load( dataPath( "icons/user_orange.png" ) );
    maGoodIcons[eBlack].load( dataPath( "icons/user_black.png" ) );

    maGoodIconsCollapsed[eRed].load( dataPath( "icons/user_red32_collapse.png" ) );
    maGoodIconsCollapsed[eBlue].load( dataPath( "icons/user_blue32_collapse.png" ) );
    maGoodIconsCollapsed[eGreen].load( dataPath( "icons/user_green32_collapse.png" ) );
    maGoodIconsCollapsed[eOrange].load( dataPath( "icons/user_orange32_collapse.png" ) );
    maGoodIconsCollapsed[eBlack].load( dataPath( "icons/user_black32_collapse.png" ) );
    
    maGoodIconsExpanded[eRed].load( dataPath( "icons/user_red32_expand.png" ) );
    maGoodIconsExpanded[eBlue].load( dataPath( "icons/user_blue32_expand.png" ) );
    maGoodIconsExpanded[eGreen].load( dataPath( "icons/user_green32_expand.png" ) );
    maGoodIconsExpanded[eOrange].load( dataPath( "icons/user_orange32_expand.png" ) );
    maGoodIconsExpanded[eBlack].load( dataPath( "icons/user_black32_expand.png" ) );

    maExclIcons[eRed].load( dataPath( "icons/user_red_caching.png" ) );
    maExclIcons[eBlue].load( dataPath( "icons/user_blue_caching.png" ) );
    maExclIcons[eGreen].load( dataPath( "icons/user_green_caching.png" ) );
    maExclIcons[eOrange].load( dataPath( "icons/user_orange_caching.png" ) );
    maExclIcons[eBlack].load( dataPath( "icons/user_black_caching.png" ) );

    maDisabledIcons[eRed].load( dataPath( "icons/user_disabled.png" ) );
    maDisabledIcons[eBlue].load( dataPath( "icons/user_disabled.png" ) );
    maDisabledIcons[eGreen].load( dataPath( "icons/user_disabled.png" ) );
    maDisabledIcons[eOrange].load( dataPath( "icons/user_disabled.png" ) );
    maDisabledIcons[eBlack].load( dataPath( "icons/user_disabled.png" ) );

    mbIconsLoaded = true;

    LOG( 4, "Icons loaded\n" );
}
