/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef LAST_FM_APPLICATION_H
#define LAST_FM_APPLICATION_H

#include <QApplication>
#include <QTranslator>


class LastFmApplication : public QApplication
{
    Q_OBJECT

    public:
        LastFmApplication( int& argc, char** argv );

        QString languageCode() const { return m_lang.left( 2 ); }
    
        enum CustomEvent
        {
            EventLoopStarted = QEvent::User + 1
        };

    public slots:
        // Switch the app to a different language
        void setLanguage( QString langCode );

    signals:
        void endSession(); // emitted when Windows shuts the app down

    protected:
        #ifdef WIN32
        virtual bool winEventFilter( MSG* msg, long* result );
        #endif

    private slots:
        void init();
        void shutdown();

    private:
        bool m_endSessionEmitted;
        QString m_lang;

		QTranslator m_translatorApp;
        QTranslator m_translatorQt;
		
        void initLogger();
        void initTranslator();
        void registerMetaTypes();

};

#endif // LASTFMAPPLICATION_H
