/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *      Max Howell, Last.fm Ltd <max@last.fm>                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include <QtGlobal>
#include <QPainter>
#include <QStyleOption>
#include <QWidget>
#include <QDebug>
#include "macstyleoverrides.h"

static const QColor kLineGrey = QColor( 0x8c, 0x8c, 0x8c );


MacStyleOverrides::MacStyleOverrides() : QMacStyle()
{}


QSize
MacStyleOverrides::sizeFromContents(
    ContentsType ct,
    const QStyleOption* opt,
    const QSize &csz,
    const QWidget* w ) const
{
    if ( ct == CT_ToolButton )
    {
        // This doesn't really work to add space above the icons and it's
        // currently not used anywhere.
        QSize defaultSize = QMacStyle::sizeFromContents( ct, opt, csz, w );
        defaultSize.setHeight( defaultSize.height() + 5 );
        return defaultSize;
    }
    else
    {
        return QMacStyle::sizeFromContents( ct, opt, csz, w );
    }
}    


void 
MacStyleOverrides::drawControl(
    ControlElement pe,
    const QStyleOption* opt,
    QPainter* p,
    const QWidget* w ) const
{
    if (pe == CE_Splitter)
    {
		p->setPen( kLineGrey );
		p->drawLine( opt->rect.topLeft(), opt->rect.bottomLeft() );
	}
    else
    {
		QMacStyle::drawControl(pe, opt, p, w);
    }
}


int
MacStyleOverrides::pixelMetric(
	PixelMetric metric,
	const QStyleOption* opt,
	const QWidget* widget ) const
{
	switch (metric)
	{
		/* didn't help removing the 1px frame around the scrollarea
		case PM_DefaultFrameWidth:
			qDebug() << "FRAME 10!";
			return 10;
		*/
		
		default:
			return QMacStyle::pixelMetric( metric, opt, widget );
    }
}


void
MacStyleOverrides::drawPrimitive(
	PrimitiveElement pe,
	const QStyleOption* opt,
	QPainter* p,
	const QWidget* w ) const
{
    if ( pe == PE_FrameStatusBar )
	{
		// We don't want no borders
	}
	else
	{
		QMacStyle::drawPrimitive( pe, opt, p, w );
	}
}


QRect
MacStyleOverrides::subElementRect(
    SubElement sr,
    const QStyleOption *opt,
    const QWidget *widget ) const
{
    QRect rect;
    switch (sr)
    {
        case SE_TabWidgetTabContents:
        {
            rect = QMacStyle::subElementRect(sr, opt, widget);
            rect.adjust( 0, 0, 1, 2 );
        }
        break;
    
        default:
        {
            rect = QMacStyle::subElementRect(sr, opt, widget);
        }
        break;
    }
	
	return rect;
}
