/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef MEDIADEVICE_H
#define MEDIADEVICE_H

#include "interfaces/MediaDeviceInterface.h"
#include <QSqlDatabase>
#include <QFile>
#include "http.h"

class MediaDevices : public QObject
{
    Q_OBJECT

    public:
        MediaDevices();
        ~MediaDevices();

        void bootStrap();

        bool zipFiles();
        void sendZip();

    signals:
        void bootstrapProgress( int percentage, const TrackInfo& track );
        void bootstrapDone();

    private slots:
        void sendFinished( int id, bool error );
        void sendProgressMade( int done, int total );
        void dataAvailable( QByteArray data );
        void headerReceived( const QHttpResponseHeader &resp );

    private:
        QSqlDatabase m_db;
        MediaDeviceInterface* m_gpod;
        QString m_savePath;

        QString m_username;
        QString m_passMd5;

        Http* m_http;
        int m_reqId;
        QFile m_zipFile;
};

#endif
