/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef SEARCH_EXTENSION_H
#define SEARCH_EXTENSION_H

#include "StationUrl.h"

#include <QFrame>

#ifdef Q_WS_MAC
#   include "ui_search_mac.h"
#else
#   include "ui_search_win.h"
#endif


class SearchExtension : public QWidget
{
    Q_OBJECT

    public:
        SearchExtension( QWidget* parent );

    public slots:
        void clearSelection();

    private slots:
        void search();
        void play();
        void searchFieldChanged();
        void requestTopTags();
        void searchResults( class Request* );
        void itemClicked( int index );
    
    private:
        StationUrl stationUrl();      
        virtual bool eventFilter( QObject* watched, QEvent* event );

    private:
        Ui::SearchExtension ui;
        QScrollArea* m_scrollArea;
        QMovie m_spinnerMovie;
        
        int m_type;
        int m_currentCloudType;
        
        bool m_topTags;
        bool m_searching;
};

#endif
