/***************************************************************************
 *   Copyright (C) 2005 - 2007 by                                          *
 *      Christian Muehlhaeuser, Last.fm Ltd <chris@last.fm>                *
 *      Erik Jaelevik, Last.fm Ltd <erik@last.fm>                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef USERINFO_EXTENSION_H
#define USERINFO_EXTENSION_H

#include <QObject>
#include <QFrame>

#include <extensioninterface.h>
#include <settingsserviceinterface.h>
#include "webservice/webservice.h"

#include <usermetadata.h>

#include "ui_userinfo.h"

class ExtendedInfoDelegate;
class QStandardItemModel;

class UserInfoExtension : public ExtensionInterface
{
    Q_OBJECT
    Q_INTERFACES( ExtensionInterface )

    public:
        UserInfoExtension();

        QString name() const { return QString( "UserInfo Extension" ); }
        QString version() const { return QString( "0.0.1" ); }
        QString tabCaption() const { return tr( "Your Friends" ); }

        QWidget* frame() { if ( !m_widget ) { initGui(); } return m_widget; }
        bool frameEnabled() { return ( m_widget != 0 ); }

        QWidget* owner() { return m_parent; }
        void setOwner( QWidget* parent ) { m_parent = parent; setParent( parent ); }

        SettingsServiceInterface *m_iSettings;

    private:
        void initGui();

        Ui::UserInfoExtension ui;
        QWidget *m_widget;
        QWidget *m_parent;

        ExtendedInfoDelegate *m_delegate;
        QStandardItemModel *m_friendsModel;

    private slots:
        void coverLoaded( int id, bool error, QIODevice* to, QString path );

        void friends();
        void updateFriends( FriendsRequest* );
};


class ExtendedInfoDelegate : public QAbstractItemDelegate
{
    Q_OBJECT

    public:
        ExtendedInfoDelegate( QObject *parent = 0 );

        void paint( QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index ) const;
        QSize sizeHint( const QStyleOptionViewItem & option, const QModelIndex & index ) const;
};

#endif
